﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Wordbee.Beebox.Extensibility;

namespace Acme.PseudoTranslationSample
{

	/// <summary>
	/// This is a sample Beebox extension that adds a simple pseudo translation option to the Beebox.
	/// </summary>
	public class SamplePseudoTranslator : BeeboxPseudoTranslator
	{


		/// <summary>
		/// Gets the globally unique id of this extension.
		/// </summary>
		public override string ExtensionID { get { return "acme1"; } }


		/// <summary>
		/// Gets if the extension is by default enabled. If false, then it must be enabled explicitly in each
		/// Beebox project from the Beebox Admin UI.
		/// </summary>
		public override bool EnableByDefault { get { return true; } }



		/// <summary>
		/// Gets a name. Displayed in the Beebox extension manager page.
		/// </summary>
		public override string Name { get { return "Acme translator"; } }


		/// <summary>
		/// Gets the title of the algorithm shown in the user interface such as the "Actions" tool
		/// where a user can pseudo translate selected content.
		/// </summary>
		public override string UITitle { get { return "Acme translator"; } }


		/// <summary>
		/// Gets a description. Displayed in the Beebox extension manager page.
		/// </summary>
		public override string Description { get { return "Some words on my algorithm..."; } }


		/// <summary>
		/// Gets version number. Displayed in the Beebox extension manager page.
		/// </summary>
		public override string Version { get { return "1.0"; } }


		/// <summary>
		/// Gets the author. Displayed in the Beebox extension manager page.
		/// </summary>
		public override string Author { get { return "Acme Ltd"; } }




		/// <summary>
		/// Override to implement your machine translation algorithm.
		/// Return null to not translate the source text. Otherwise return the translation.
		/// 
		/// Basically this method is called with each source text. 
		/// - Translate "text" and return the result.
		/// - Return null if the source text shall be left as is.
		/// </summary>
		/// <param name="text">The text to translate</param>
		/// <param name="sourceLocale">The ISO code of the source language</param>
		/// <param name="targetLocale">The ISO code of the target language</param>
		/// <param name="context">Contains additional information on the segment including the project key and the source file containing the text.</param>
		/// <param name="configuration">The extension's parameters. 
		/// You need to implement the respective virtual methods to permit configuring the parameter individually per project.</param>
		/// <returns>
		/// Return the translated text.
		/// Return null to not change the current translation (null will not clear the translation!)
		/// </returns>
		public override string Translate(
					string text, 
					string sourceLocale, 
					string targetLocale, 
					SegmentContext context, 
					IExtensionConfiguration configuration)
		{
			StringBuilder sb = new StringBuilder(text.Length);
			
			// This sample shows how to pseudo translate by converting all characters to uppercase.
			// The code is a bit more complicate than one might imagine... The reason is that the
			// source text may contain "markup". Think of html tags such as in "Click <a>here</a>".
			// We do not want markup converted and so we must have some logic to skip markup when transforming text.

			bool intag = false;
			foreach (char ch in text)
			{
				// Skip any markup. Markup is enclosed between special codes (char)1 and (char)2.
				if (ch == ExtensionsHelper.TAG_MARKER_CLOSE) { sb.Append(ch); intag = false; continue; }	// We have finished markup
				if (ch == ExtensionsHelper.TAG_MARKER_OPEN) intag = true;					// Markup is starting here
				if (intag) { sb.Append(ch); continue; }										// In the middle of markup

				// Now we transform the character to uppercase
				sb.Append(char.ToUpper(ch));
			}

			return sb.ToString();
		}

	}
}


