﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Wordbee.Beebox.Extensibility;


namespace Acme.PseudoTranslationSample
{

	/// <summary>
	/// This is a simple Beebox extension that adds a text filter option to the user interface.
	/// </summary>
	public class SampleTextFilter : BeeboxTextFilter
	{

		/// <summary>
		/// Gets the globally unique id of this extension.
		/// </summary>
		public override string ExtensionID { get { return "acme2"; } }


		/// <summary>
		/// Gets if the extension is by default enabled. If false, then it must be enabled explicitly in each
		/// Beebox project from the Beebox Admin UI.
		/// </summary>
		public override bool EnableByDefault { get { return true; } }



		/// <summary>
		/// Gets a name. Displayed in the Beebox extension manager page.
		/// </summary>
		public override string Name { get { return "Acme QA filter"; } }


		/// <summary>
		/// Gets the title of the algorithm shown in the user interface such as the "Actions" tool where a user can pseudo translate
		/// selected content.
		/// </summary>
		public override string UITitle { get { return "Acme - Missing translations"; } }


		/// <summary>
		/// Gets a description. Displayed in the Beebox extension manager page.
		/// </summary>
		public override string Description { get { return "Some words on my algorithm..."; } }


		/// <summary>
		/// Gets version number. Displayed in the Beebox extension manager page.
		/// </summary>
		public override string Version { get { return "1.0"; } }


		/// <summary>
		/// Gets the author. Displayed in the Beebox extension manager page.
		/// </summary>
		public override string Author { get { return "Acme Ltd"; } }




		/// <summary>
		/// Return true if the segment passes the filter. Otherwise do return false.
		/// </summary>
		/// <param name="segment">
		/// Segment details with source text, translation and additional properties:
		/// - Source: The original text
		/// - Target: The translated text (can be null or "" to indicate no translation yet)
		/// - SourceLocale: The source language code
		/// - TargetLocale: The target language code
		/// - Status: The Quality Assurance status: 0 = not set, 1 = QA Ok, 2 = QA Error
		/// - Validated: The translation currently is approved or not
		/// - Locked: The translation is locked for editing by the user
		/// - File: The file name containing the segment
		/// - Project: The project key
		/// - Key: Gets the segment key or the context of the segment. File format dependent: "Heading 1", "Hyperlink", ...
		/// - SourceNext: The text just before this segment
		/// - SourcePrevious: The text just after this segment
		/// </param>
		/// <param name="configuration">The extension's parameters. You need to implement the respective virtual methods to permit configuring the parameter individually per project.</param>
		/// <returns>
		/// True: The filter retains the segment
		/// False: The filter discards the segment
		/// </returns>
		public override bool IsMatch(Segment segment, IExtensionConfiguration configuration)
		{
			// We want all empty translations!
			if (string.IsNullOrWhiteSpace(segment.Target)) return true;

			// Those with content we skip!
			return false;
		}


	}
}
