﻿using System.Collections.Generic;
using Wordbee.Beebox.Extensibility;

namespace Wordbee.Beebox.Extensions.GitPackage
{
	public class SingleBranchProcessor
	{

		/// <summary>
		/// To synchronize "in" folder with a single specific branch.
		/// </summary>
		/// <param name="inDirectory"></param>
		/// <param name="logDirectory"></param>
		/// <param name="initial"></param>
		/// <param name="settings"></param>
		/// <returns>
		/// Events for the results
		/// </returns>
		public List<LogItem> Run(string inDirectory, string logDirectory, bool initial, GitSettings settings)
		{
			var proxy = new GitProxy(settings, inDirectory, logDirectory);

			if (initial)
			{
				// Before the Autorun we pull any new content
				proxy.SyncGitToBeebox();
			}
			else
			{
				// At end of Autorun we push any finished translations
				proxy.SyncBeeboxToGit();
			}

			return proxy.LogItems;
		}


	}
}
