﻿using Newtonsoft.Json;

namespace Wordbee.Beebox.Extensions.GitPackage
{
	/// <summary>
	/// Configuration of git connector in a project
	/// </summary>
	public partial class GitSettings
	{

		/// <summary>
		/// We use this code for the remote repo
		/// </summary>
		public const string OriginName = "origin";


		/// <summary>
		/// The GIT url
		/// </summary>
		[JsonProperty(PropertyName = "url")]
		public string Url { get; set; }


		/// <summary>
		/// The username used for GIT authentication
		/// </summary>
		[JsonProperty(PropertyName = "username")]
		public string Username { get; set; }


		/// <summary>
		/// The password used for GIT authentication
		/// </summary>
		[JsonProperty(PropertyName = "password")]
		public string Password { get; set; }


		/// <summary>
		/// The GIT branch name that we push/pull
		/// </summary>
		[JsonProperty(PropertyName = "branch")]
		public string BranchName { get; set; }



		/// <summary>
		/// Signature name of committing user
		/// </summary>
		[JsonProperty(PropertyName = "signatureName")]
		public string SignatureName { get; set; } = "Wordbee";


		/// <summary>
		/// Signature email of committing user
		/// </summary>
		[JsonProperty(PropertyName = "signatureEmail")]
		public string SignatureEmail { get; set; } = "noreply@wordbee.com";



		/// <summary>
		/// Gets if project connects to multiple target branches in repository.
		/// </summary>
		[JsonProperty(PropertyName = "multibranch")]
		public MultibranchSettings Multibranch { get; set; } = new MultibranchSettings();

		

		/// <summary>
		/// Validate parameters
		/// </summary>
		/// <returns></returns>
		public string Validate()
		{
			Url = Url?.Trim();
			Username = Username?.Trim();
			Password = Password?.Trim();
			BranchName = BranchName?.Trim();

			if (string.IsNullOrWhiteSpace(Url)) return "GIT repository URL is not specified.";
			if (string.IsNullOrWhiteSpace(Username)) return "GIT username is not specified.";
			if (string.IsNullOrWhiteSpace(Password)) return "GIT password is not specified.";
			if (string.IsNullOrWhiteSpace(BranchName)) return "GIT branchname is not specified.";

			Multibranch = Multibranch ?? new MultibranchSettings();
			Multibranch.Validate();

			return null;
		}



	}
}
